import { z } from "zod"

export const vehicleCategorySchema = z.object({
  name: z
    .string()
    .min(2, "Category name must be at least 2 characters")
    .max(50, "Category name is too long")
    .regex(/^[a-zA-Z\s]+$/, "Category name can only contain letters and spaces"),
})

export const vehicleSchema = z.object({
  name: z.string().min(2, "Vehicle name must be at least 2 characters").max(100, "Vehicle name is too long"),
  categoryId: z.string().min(1, "Please select a category"),
  photo: z.string().min(1, "Vehicle photo is required"),
  mileage: z
    .number({ invalid_type_error: "Mileage must be a number" })
    .min(1, "Mileage must be at least 1 km/l")
    .max(100, "Mileage seems too high"),
  perKmPrice: z
    .number({ invalid_type_error: "Per KM price must be a number" })
    .min(1, "Per KM price must be at least ₹1")
    .max(1000, "Per KM price seems too high"),
  perDayPrice: z
    .number({ invalid_type_error: "Per day price must be a number" })
    .min(100, "Per day price must be at least ₹100")
    .max(100000, "Per day price seems too high"),
})

export type VehicleCategoryInput = z.infer<typeof vehicleCategorySchema>
export type VehicleInput = z.infer<typeof vehicleSchema>
