/**
 * TEERTHAM PLATFORM - TEST CREDENTIALS REFERENCE
 *
 * This file documents all test credentials for the Teertham platform.
 * NO API CALLS - All authentication uses centralized mock data from /lib/data/users.ts
 */

export const testCredentials = {
  // Admin Login
  admin: {
    email: "admin@teertham.com",
    password: "Admin@123",
    accessUrl: "/admin/login",
    dashboardUrl: "/admin/dashboard",
  },

  // Customer Account
  customer: {
    email: "customer@teertham.com",
    password: "Customer@123",
    loginUrl: "/customer-account",
    signupUrl: "/customer-account",
  },

  // Agent Account
  agent: {
    email: "agent@teertham.com",
    password: "Agent@123",
    loginUrl: "/agent-account",
    signupUrl: "/agent-account",
  },

  // Password Reset Flow
  passwordReset: {
    // Any registered email can trigger password reset
    forgetPasswordUrl: "/forget-password",
    otpVerificationUrl: "/otp-verification",
    resetPasswordUrl: "/reset-password",
    // OTP is generated dynamically (6-digit code)
    // Default OTP for testing: "123456" (shown in toast after requesting)
    testOTP: "123456",
  },
} as const

/**
 * Authentication Flow Summary:
 *
 * 1. ADMIN LOGIN (/admin/login)
 *    - Uses admin@teertham.com / Admin@123
 *    - Redirects to /admin/dashboard on success
 *    - Session stored in sessionStorage as 'admin_session'
 *
 * 2. CUSTOMER ACCOUNT (/customer-account)
 *    - Login tab: customer@teertham.com / Customer@123
 *    - Signup tab: Create new customer account
 *    - Session stored as 'customer_session'
 *
 * 3. AGENT ACCOUNT (/agent-account)
 *    - Login tab: agent@teertham.com / Agent@123
 *    - Signup tab: Create new agent account
 *    - Session stored as 'agent_session'
 *
 * 4. PASSWORD RESET FLOW
 *    - Step 1: Enter email at /forget-password
 *    - Step 2: Enter OTP at /otp-verification (OTP shown in toast)
 *    - Step 3: Set new password at /reset-password
 *    - Uses sessionStorage for flow tracking
 *
 * 5. ADMIN PASSWORD RESET (/admin/forget-password → /admin/email-otp-confirmation → /admin/reset-password)
 *    - Similar flow but for admin users only
 *    - Uses admin@teertham.com
 */

export const dataStorageLocations = {
  users: "/lib/data/users.ts",
  validations: "/lib/validations/auth.ts",
  credentials: "/lib/data/credentials-reference.ts",
} as const

export const sessionStorageKeys = {
  admin: "admin_session",
  customer: "customer_session",
  agent: "agent_session",
  resetEmail: "reset_email",
  otpVerified: "otp_verified",
} as const
