"use client"

import { Card, CardContent, CardHeader, CardTitle, CardDescription } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"
import { Label } from "@/components/ui/label"
import { Switch } from "@/components/ui/switch"
import { KeyRound, Shield, Smartphone, History, AlertTriangle } from "lucide-react"

export function SecuritySettings() {
  return (
    <div className="space-y-6">
      {/* Change Password */}
      <Card className="border bg-card">
        <CardHeader>
          <div className="flex items-center gap-3">
            <div className="p-2 rounded-lg bg-blue-500">
              <KeyRound className="h-5 w-5 text-white" />
            </div>
            <div>
              <CardTitle>Change Password</CardTitle>
              <CardDescription>Update your account password</CardDescription>
            </div>
          </div>
        </CardHeader>
        <CardContent className="space-y-4">
          <div className="space-y-2">
            <Label htmlFor="currentPassword">Current Password</Label>
            <Input id="currentPassword" type="password" placeholder="Enter current password" />
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div className="space-y-2">
              <Label htmlFor="newPassword">New Password</Label>
              <Input id="newPassword" type="password" placeholder="Enter new password" />
            </div>
            <div className="space-y-2">
              <Label htmlFor="confirmPassword">Confirm New Password</Label>
              <Input id="confirmPassword" type="password" placeholder="Confirm new password" />
            </div>
          </div>

          <div className="p-3 rounded-lg bg-muted/50 border border-border">
            <p className="text-xs text-muted-foreground">
              Password must be at least 8 characters long and include uppercase, lowercase, numbers, and special
              characters.
            </p>
          </div>

          <Button className="bg-slate-900 hover:bg-slate-800 dark:bg-white dark:text-slate-900 dark:hover:bg-slate-100">
            Update Password
          </Button>
        </CardContent>
      </Card>

      {/* Two-Factor Authentication */}
      <Card className="border bg-card">
        <CardHeader>
          <div className="flex items-center gap-3">
            <div className="p-2 rounded-lg bg-emerald-500">
              <Smartphone className="h-5 w-5 text-white" />
            </div>
            <div>
              <CardTitle>Two-Factor Authentication</CardTitle>
              <CardDescription>Add an extra layer of security to your account</CardDescription>
            </div>
          </div>
        </CardHeader>
        <CardContent className="space-y-4">
          <div className="flex items-center justify-between p-4 rounded-xl bg-muted/30 border border-border/50">
            <div>
              <p className="font-medium">SMS Authentication</p>
              <p className="text-sm text-muted-foreground">Receive codes via SMS</p>
            </div>
            <Switch />
          </div>

          <div className="flex items-center justify-between p-4 rounded-xl bg-muted/30 border border-border/50">
            <div>
              <p className="font-medium">Email Authentication</p>
              <p className="text-sm text-muted-foreground">Receive codes via email</p>
            </div>
            <Switch defaultChecked />
          </div>

          <div className="flex items-center justify-between p-4 rounded-xl bg-muted/30 border border-border/50">
            <div>
              <p className="font-medium">Authenticator App</p>
              <p className="text-sm text-muted-foreground">Use Google Authenticator or similar</p>
            </div>
            <Switch />
          </div>
        </CardContent>
      </Card>

      {/* Login Sessions */}
      <Card className="border bg-card">
        <CardHeader>
          <div className="flex items-center gap-3">
            <div className="p-2 rounded-lg bg-violet-500">
              <History className="h-5 w-5 text-white" />
            </div>
            <div>
              <CardTitle>Active Sessions</CardTitle>
              <CardDescription>Manage your active login sessions</CardDescription>
            </div>
          </div>
        </CardHeader>
        <CardContent className="space-y-4">
          <div className="p-4 rounded-xl bg-emerald-50 dark:bg-emerald-950/30 border border-emerald-200 dark:border-emerald-800">
            <div className="flex items-center justify-between">
              <div>
                <p className="font-medium text-emerald-700 dark:text-emerald-300">Current Session</p>
                <p className="text-sm text-emerald-600 dark:text-emerald-400">Chrome on Windows - Varanasi, India</p>
                <p className="text-xs text-emerald-500 dark:text-emerald-500">Last active: Just now</p>
              </div>
              <Shield className="h-5 w-5 text-emerald-500" />
            </div>
          </div>

          <div className="p-4 rounded-xl bg-muted/30 border border-border/50">
            <div className="flex items-center justify-between">
              <div>
                <p className="font-medium">Mobile App</p>
                <p className="text-sm text-muted-foreground">Android - Mumbai, India</p>
                <p className="text-xs text-muted-foreground">Last active: 2 hours ago</p>
              </div>
              <Button variant="ghost" size="sm" className="text-red-500 hover:text-red-600">
                Revoke
              </Button>
            </div>
          </div>

          <Button
            variant="outline"
            className="w-full text-red-500 hover:text-red-600 hover:bg-red-50 dark:hover:bg-red-950 bg-transparent"
          >
            <AlertTriangle className="h-4 w-4 mr-2" />
            Logout All Other Sessions
          </Button>
        </CardContent>
      </Card>
    </div>
  )
}
