import type { Metadata } from "next"
import { HotelPageWrapper } from "@/components/hotel/hotel-page-wrapper"
import { DashboardStats } from "@/components/hotel/dashboard/dashboard-stats"
import { RecentBookings } from "@/components/hotel/dashboard/recent-bookings"
import { QuickActions } from "@/components/hotel/dashboard/quick-actions"
import { RevenueChart } from "@/components/hotel/dashboard/revenue-chart"
import { UpcomingCheckIns } from "@/components/hotel/dashboard/upcoming-checkins"

export const metadata: Metadata = {
  title: "Dashboard",
  description: "Overview of your hotel performance, bookings, and revenue statistics",
}

export default function HotelDashboardPage() {
  return (
    <HotelPageWrapper>
      <div className="space-y-6 lg:space-y-8">
        {/* Page Header */}
        <header>
          <h1 className="text-3xl font-bold tracking-tight text-foreground">Dashboard</h1>
          <p className="text-muted-foreground mt-1">Welcome back! Here&apos;s an overview of your hotel performance.</p>
        </header>

        {/* Stats Section */}
        <section aria-labelledby="stats-heading">
          <h2 id="stats-heading" className="sr-only">
            Hotel Statistics
          </h2>
          <DashboardStats />
        </section>

        {/* Revenue Chart Section */}
        <section aria-labelledby="revenue-heading">
          <h2 id="revenue-heading" className="sr-only">
            Revenue Overview
          </h2>
          <RevenueChart />
        </section>

        {/* Content Grid */}
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-6">
          <section className="lg:col-span-2" aria-labelledby="bookings-heading">
            <h2 id="bookings-heading" className="sr-only">
              Recent Bookings
            </h2>
            <RecentBookings />
          </section>
          <aside className="space-y-6" aria-label="Quick actions and upcoming check-ins">
            <QuickActions />
            <UpcomingCheckIns />
          </aside>
        </div>
      </div>
    </HotelPageWrapper>
  )
}
