"use client"

import { useEffect } from "react"
import { Button } from "@/components/ui/button"
import { Card, CardContent, CardDescription, CardFooter, CardHeader, CardTitle } from "@/components/ui/card"
import Link from "next/link"

export default function AdminError({
  error,
  reset,
}: {
  error: Error & { digest?: string }
  reset: () => void
}) {
  useEffect(() => {
    if (process.env.NODE_ENV === "development") {
      // Only log in development
    }
  }, [error])

  return (
    <main className="min-h-screen flex items-center justify-center p-4">
      <Card className="max-w-md w-full">
        <CardHeader>
          <CardTitle>Admin Error</CardTitle>
          <CardDescription>An error occurred in the admin panel. Please try again.</CardDescription>
        </CardHeader>
        <CardContent>
          <p className="text-sm text-muted-foreground">
            {process.env.NODE_ENV === "development" ? error.message : "An unexpected error occurred"}
          </p>
        </CardContent>
        <CardFooter className="flex gap-4">
          <Button onClick={reset} className="flex-1">
            Try again
          </Button>
          <Button variant="outline" asChild className="flex-1 bg-transparent">
            <Link href="/admin/dashboard">Go to dashboard</Link>
          </Button>
        </CardFooter>
      </Card>
    </main>
  )
}
